// instruction table
// Thanks to Rik Bonnet for his fixes and additions to the table
// last modified at 26 11 2002 
var instrTab = Array();      //Opcode look up table
instrTab[0]  = Array("addwf",     "*,*", 0x0700,	"dualAWDst",0xFF00,	0xCF);
instrTab[1]  = Array("andwf",     "*,*", 0x0500,	"dualAWDst",0xFF00,	0xCF);
//instrTab[2]  = Array("clrf",      "*",   0x0180,	"dualAWDst",0xFF80,	0xCF);    // check this one !!!!!! it was oneArg
instrTab[2]  = Array('clrf',	  '*',  0x0180,      'oneArg' ,0xFF80, 0x7F); //by Rik Bonnet
instrTab[3]  = Array("clrw",      "",    0x0100,	"asIs"     ,0xFF80		);
instrTab[4]  = Array("comf",      "*,*", 0x0900,	"dualAWDst",0xFF00,	0xCF);
instrTab[5]  = Array("decf",      "*,*", 0x0300,	"dualAWDst",0xFF00,	0xCF);
instrTab[6]  = Array("decfsz",    "*,*", 0x0B00,	"dualAWDst",0xFF00,	0xCF);
instrTab[7]  = Array("incf",      "*,*", 0x0A00,	"dualAWDst",0xFF00,	0xCF);
instrTab[8]  = Array("incfsz",    "*,*", 0x0F00,	"dualAWDst",0xFF00,	0xCF);
instrTab[9]  = Array("iorwf",     "*,*", 0x0400,	"dualAWDst",0xFF00,	0xCF);
instrTab[10] = Array("movf",      "*,*", 0x0800,	"dualAWDst",0xFF00,	0xCF);
//instrTab[11] = Array("movwf",     "*",   0x0080,	"dualAWDst",0xFF80,	0xCF); // check this one !!!!!! it was oneArg
instrTab[11] = Array('movwf',	  '*',  0x0080,      'oneArg'   ,0xFF80,     0x7F); //by Rik Bonnet
instrTab[12] = Array("nop",  	  "",    0x0000,	"asIs"     ,0xFF9F		);
instrTab[13] = Array("rlf",	      "*,*", 0x0D00,	"dualAWDst",0xFF00,	0xCF);
instrTab[14] = Array("rrf",	      "*,*", 0x0C00,	"dualAWDst",0xFF00,	0xCF);
instrTab[15] = Array("subwf",     "*,*", 0x0200,	"dualAWDst",0xFF00,	0xCF);
instrTab[16] = Array("swapf",     "*,*", 0x0E00,	"dualAWDst",0xFF00,	0xCF);
instrTab[17] = Array("xorwf",     "*,*", 0x0600,	"dualAWDst",0xFF00,	0xCF);
instrTab[18] = Array("bcf",	      "*,*", 0x1000,	"bit",	    0xFC00,	0xCF);
instrTab[19] = Array("bsf",	      "*,*", 0x1400,	"bit",	    0xFC00,	0xCF);
instrTab[20] = Array("btfsc",     "*,*", 0x1800,	"bit",	    0xFC00,	0xCF);
instrTab[21] = Array("btfss",     "*,*", 0x1C00,	"bit",	    0xFC00,	0xCF);
instrTab[22] = Array("addlw",     "*",   0x3E00,	"oneArg",	0xFE00,	0x00FF);
instrTab[23] = Array("andlw",     "*",   0x3900,	"oneArg",	0xFF00,	0x00FF);
instrTab[24] = Array("call",      "*",   0x2000,	"oneArg",	0xF800,	0x07FF);
instrTab[25] = Array("clrwdt",    "",    0x0064,	"asIs"     ,0xFFFF			);
instrTab[26] = Array("goto",      "*",   0x2800,	"oneArg",	0xF800,	0x07FF);
instrTab[27] = Array("iorlw",     "*",   0x3800,	"oneArg",	0xFF00,	0x00FF);
instrTab[28] = Array("movlw",     "*",   0x3000,	"oneArg",	0xFC00,	0x00FF);
instrTab[29] = Array("retfie",    "",    0x0009,	"asIs"     ,0xFFFF			);
instrTab[30] = Array("retlw",     "*",   0x3400,	"oneArg",	0xFC00,	0x00FF);
instrTab[31] = Array("return",    "",    0x0008,	"asIs"     ,0xFFFF			);
instrTab[32] = Array("sleep",     "",    0x0063,	"asIs"     ,0xFFFF			);
instrTab[33] = Array("sublw",     "*",   0x3C00,	"oneArg",	0xFE00,	0x00FF	);
instrTab[34] = Array("xorlw",     "*",   0x3A00,	"oneArg",	0xFF00,	0x00FF	);
//instrTab[35] = Array("tris",      "*",   0x0060,	"oneArg",	0xFFF8, 	0x0007);
instrTab[35] = Array("option",    "",    0x0062,     "asIs",           0xFFFF );
instrTab[36] = Array("illegal opcode",    "",   0x0061,    "asIs",           0xFFFF);
instrTab[37] = Array("illegal opcode",    "",   0x0060,    "asIs",           0xFFFF);
instrTab[38] = Array("tris",      "*",   0x0060,     "oneArg",   0xFFF8,     0x0007);



var equArry = Array();//radix is HEX
var equStr = 0; //string
var equStrVal = 1;//value of string
var	clrNdx = 2; // type of text to color

equArry[0]  =  Array("w",0x0000,13);
equArry[1]  =  Array("f",0x0001,13);
//----- Register Files Page 0 ------------
equArry[2]  =  Array("indf"  ,0x0000,0);
equArry[3]  =  Array("tmr0"  ,0x0001,0);
equArry[4]  =  Array("pcl"   ,0x0002,2);	//Duplicated in Page 1
equArry[5]  =  Array("status",0x0003,2);	//Duplicated in Page 1
equArry[6]  =  Array("fsr"   ,0x0004,2);	//Duplicated in Page 1
equArry[7]  =  Array("porta" ,0x0005,0);
equArry[8]  =  Array("portb" ,0x0006,0);
equArry[9]  =  Array("eedata",0x0008,0);
equArry[10] =  Array("eeadr" ,0x0009,0);
equArry[11] =  Array("pclath",0x000A,2);	//Duplicated in Page 1
equArry[12] =  Array("intcon",0x000B,2);	//Duplicated in Page 1
//----- Register Files Page 1 ------------
equArry[13] =  Array("option_reg",0x0081,1);
equArry[14] =  Array("trisa"     ,0x0085,1);
equArry[15] =  Array("trisb"     ,0x0086,1);
equArry[16] =  Array("eecon1"    ,0x0088,1);
equArry[17] =  Array("eecon2"    ,0x0089,1);
//;----- STATUS Bits ---------------------
equArry[18] =  Array("irp"   ,0x0007,3);
equArry[19] =  Array("rp1"   ,0x0006,3);
equArry[20] =  Array("rp0"   ,0x0005,3);
equArry[21] =  Array("not_to",0x0004,3);
equArry[22] =  Array("not_pd",0x0003,3);
equArry[23] =  Array("z"     ,0x0002,3);
equArry[24] =  Array("dc"    ,0x0001,3);
equArry[25] =  Array("c"     ,0x0000,3);
//;----- INTCON Bits ---------------------
equArry[26] =  Array("gie" ,0x0007,4);
equArry[27] =  Array("eeie",0x0006,4);
equArry[28] =  Array("t0ie",0x0005,4);
equArry[29] =  Array("inte",0x0004,4);
equArry[30] =  Array("rbie",0x0003,4);
equArry[31] =  Array("t0if",0x0002,4);
equArry[32] =  Array("intf",0x0001,4);
equArry[33] =  Array("rbif",0x0000,4);
//;----- OPTION Bits ---------------------
equArry[34] =  Array("not_rbpu",0x0007,5);
equArry[35] =  Array("intedg"  ,0x0006,5);
equArry[36] =  Array("t0cs"    ,0x0005,5);
equArry[37] =  Array("t0se"    ,0x0004,5);
equArry[38] =  Array("psa"     ,0x0003,5);
equArry[39] =  Array("ps2"     ,0x0002,5);
equArry[40] =  Array("ps1"     ,0x0001,5);
equArry[41] =  Array("ps0"     ,0x0000,5);
//;----- EECON1 Bits ---------------------
equArry[42] =  Array("eeif" ,0x0004,6);
equArry[43] =  Array("wrerr",0x0003,6);
equArry[44] =  Array("wren" ,0x0002,6);
equArry[45] =  Array("wr"   ,0x0001,6);
equArry[46] =  Array("rd"   ,0x0000,6);
//;----- Extra/Duplicates ---------------------
equArry[47] =  Array("carry"     ,0x0000,3);// status bit

//;----- Config bits ---------------------
equArry[48]  =  Array("_cp_on"	,0x000F,7);
equArry[49]  =  Array("_cp_off"	,0x3FFF,7);
equArry[50]  =  Array("_pwrte_on"	,0x3FF7,7);
equArry[51]  =  Array("_pwrte_off",0x3FFF,7);
equArry[52]  =  Array("_wdt_on"	,0x3FFF,7);
equArry[53]  =  Array("_wdt_off"	,0x3FFB,7);
equArry[54]  =  Array("_lp_osc"	,0x3FFC,7);
equArry[55]  =  Array("_xt_osc"	,0x3FFD,7);
equArry[56]  =  Array("_hs_osc"	,0x3FFE,7);
equArry[57]  =  Array("_rc_osc"	,0x3FFF,7);


var asciiTable = " "+"!"+'\"'+"#"+"$"+"%"+"&"+'\''+"("+")"+"*"+"+"+","+"-"+"."+"/"+"0"+"1"+"2"+"3"+"4"+"5"+"6"+"7"+"8"+"9"+":"+";"+"<"+"="+">"+"?"+"@"+"A"+"B"+"C"+"D"+"E"+"F"+"G"+"H"+"I"+"J"+"K"+"L"+"M"+"N"+"O"+"P"+"Q"+"R"+"S"+"T"+"U"+"V"+"W"+"X"+"Y"+"Z"+"["+"\\"+"]"+"^"+"_"+"`"+"a"+"b"+"c"+"d"+"e"+"f"+"g"+"h"+"i"+"j"+"k"+"l"+"m"+"n"+"o"+"p"+"q"+"r"+"s"+"t"+"u"+"v"+"w"+"x"+"y"+"z"+"{"+"|"+"}"+"~"+"";

var asmDirArry = Array();
asmDirArry[0] = "equ";
asmDirArry[1] = "org";
asmDirArry[2] = "dt";
asmDirArry[3] = "radix";
asmDirArry[4] = "__config";
asmDirArry[5] = "macro";
asmDirArry[6] = "endm";
asmDirArry[7] = "data";
asmDirArry[8] = "if";
asmDirArry[9] = "else";
asmDirArry[10] = "end";
asmDirArry[11] = "elif";
asmDirArry[12] = "include";
asmDirArry[13] = "errorlevel";
asmDirArry[14] = "list";
asmDirArry[15] = "__idlocs";
asmDirArry[16] = "de";
asmDirArry[17] ="db";
asmDirArry[18] ="data";
asmDirArry[19] ="#define";
asmDirArry[20] ="dw";
asmDirArry[21] ="endc";
asmDirArry[22] ="endif";
asmDirArry[23] ="endw";
asmDirArry[24] ="error";
asmDirArry[25] ="exitm";
asmDirArry[26] ="expand";
asmDirArry[27] ="extern";
asmDirArry[28] ="fill";
asmDirArry[29] ="global";
asmDirArry[30] ="ifdef";
asmDirArry[31] ="ifndef";
asmDirArry[32] ="include";
asmDirArry[33] ="local";
asmDirArry[34] ="__maxram";
asmDirArry[35] ="messg";
asmDirArry[36] ="noexpand";
asmDirArry[37] ="nolist";
asmDirArry[38] ="page";
asmDirArry[39] ="pagesel";
asmDirArry[40] ="processor";
asmDirArry[41] ="res ";
asmDirArry[42] ="set";
asmDirArry[43] ="space";
asmDirArry[44] ="subtitle";
asmDirArry[45] ="title";
asmDirArry[46] ="#undefine";
asmDirArry[47] ="while";

//rules for operators
var rule = 1 ;//dim 2
var oprtr = 0; //dim 1
var binary = 0;
var unary = 1;
var both = 2;
var lpar = 3;
var rpar = 4;

var operArry = Array();

operArry[0 ] = 	Array(",",binary);
operArry[1 ] = 	Array("%",binary);
operArry[2 ] = 	Array("++",unary);
operArry[3 ] = 	Array("+",both);
operArry[4 ] = 	Array("+=",binary);
operArry[5 ] = 	Array("--",unary);
operArry[6 ] =	Array("-=",binary);
operArry[7 ] = 	Array("-",both);
operArry[8 ] =	Array("*=",binary);
operArry[9 ] = 	Array("*",binary);
operArry[10] =	Array("/=",binary);
operArry[11] = 	Array("/",binary);
operArry[12] =	Array(">=",binary);
operArry[13] = 	Array("&&",binary);
operArry[14] =	Array("&=",binary);
operArry[15] =	Array("&",binary);
operArry[16] =	Array("||",binary);
operArry[17] =	Array("|=",binary);
operArry[18] =	Array("|",binary);
operArry[19] =	Array("==",binary);
operArry[20] =	Array("<<=",binary);
operArry[21] =	Array(">>=",binary);
operArry[22] =	Array("<<",binary);
operArry[23] =	Array(">>",binary);
operArry[24] =	Array("<=",binary);
operArry[25] =	Array(">=",binary);
operArry[26] =	Array(">",binary);
operArry[27] =	Array("<",binary);
operArry[28] =	Array("!=",binary);
operArry[29] =	Array("!",unary);
operArry[30] =	Array("^=",binary);
operArry[31] =	Array("^",binary);
operArry[32] =	Array("%=",binary);
operArry[33] =	Array("(",lpar);
operArry[34] =	Array(")",rpar);
operArry[35] =	Array("=",binary);
operArry[36] =	Array("~",unary);
