"""lcdAmp, displays current track name of Winamp on an LCD connected to the printer port."""
# Requires:
#    Winamp module by Shalabh Chaturvedi
#    Winamp (Tested with Winamp 2.77 on Windows 2000)
#    Win32  
#    Python Win32 extensions

import winamp   
import pyLCD           
import time

def delay(): time.sleep(0.2) # 0.2 second delay
pyLCD.fs1line()
pyLCD.ems(incr = 1, shift = 1)
pyLCD.clear()
pyLCD.dispOn()
pyLCD.ddradrs(15)

w = winamp.winamp()


def print_song():
    prevTrackNum = -1
    while 1:
        currTrackNum = w.getCurrentTrack()         
        if currTrackNum != prevTrackNum :
            trackName = w.getCurrentTrackName()
            prevTrackNum = currTrackNum
            pyLCD.putstr(trackName)
        for char in trackName:
            pyLCD.data(ord(char))
            delay()

if __name__ == '__main__':
    print "The song title should be scrolling on your display now."
    print_song()               

