 /************************************************************************
  *   Driver for Graphic LCD Display 128x64                  						 *
	* 			  with HITACHI HD61202 LCD driver                      				 *
  *   Version:    1.1                                                    *
  *   Created:    04.10.00 12:43                                         *
  *   Author:     Gregor Horvat                                          *
  *   www:     		http:\\www.silon.si\grega\index.html                   *
  *   email:     	grega@silon.si                                         *
  ************************************************************************/
#include <io.h>

#define glcd_DATAPORT			 	PORTA  							// gLCD Data Port
#define glcd_CNTRPORT			 	PORTC  							// gLCD Control Port

#define glcd_DataOut        glcd_DATAPORT 			// gLCD Data Port
#define glcd_DataDir        glcd_DATAPORT - 1		// gLCD Data Direction Port
#define glcd_DataIn         glcd_DATAPORT - 2		// gLCD Data Pin Port
#define glcd_sBUSY          7     							// Busy Flag  : 1=active
#define glcd_sONOFF         5     							// OnOff Flag : 1=on,0=off
#define glcd_sRESET         4     							// Reset Flag : 1=active

#define glcd_Control        glcd_CNTRPORT 			// gLCD Control Port
#define glcd_ContDir        glcd_CNTRPORT - 1  	// gLCD Control Direction
#define glcd_ContIn         glcd_CNTRPORT - 2 	// gLCD Control Pin Port

#define glcd_RS             0  	//Register select : 1=data reg., 0=instr. reg.
#define glcd_RW             1 	//ReadWrite       : 0=write, 1=read
#define glcd_Enable         2  	//Enable          : 1=active
#define glcd_CS1            3  	//Chip Select 1   : 1=active
#define glcd_CS2            4  	//Chip Select 2   : 1=active
#define glcd_backLED        5  	//BackLight       : 1=active
#define glcd_Reset          6  	//Reset           : 0=active
#define DISPLAY_ON					0x3f
#define DISPLAY_OFF					0x3e
#define DISPLAY_SET_Y       0x40
#define DISPLAY_SET_X       0xb8
#define DISPLAY_START_LINE	0xc0

#define LINE1		0
#define LINE2		1
#define LINE3		2
#define LINE4		3
#define LINE5		4
#define LINE6		5
#define LINE7		6
#define LINE8		7

#define ON			1
#define OFF			0

void glcd_GoTo(unsigned char x, unsigned char y);  	// x(0:127), y(0:7)

void glcd_PutChr(unsigned char chr);               	//from ASCII(32) to ASCII(127)
void glcd_PutStr(unsigned char *data);             	//same except ASCII(34)"
                                                  	//for ASCII(92)"\" write "\\"

void glcd_BackLight(unsigned char a);

void glcd_SetDot(unsigned char x, unsigned char y);
void glcd_ClrDot(unsigned char x, unsigned char y);
void glcd_StartLine(unsigned char start);  // ( 0 : 63 )
void glcd_ClrScr(void);

void glcd_Circle(unsigned char xcenter, unsigned char ycenter, unsigned char radius);
void glcd_Rectangle(unsigned char x, unsigned char y, unsigned char a, unsigned char b);

void glcd_Init(void);
void glcd_Delay(unsigned int p);
void glcd_WaitIfBusy(void);
void glcd_WaitIfReset(void);
void glcd_WriteCommand(unsigned char Command);
void glcd_WriteData(unsigned char Data);
unsigned char glcd_ReadData(void);
void glcd_Set_X_adrress(unsigned char Xadrress);
void glcd_Set_Y_adrress(unsigned char Yadrress);