 /************************************************************************
  *   Driver for Graphic LCD Display 128x64                  						 *
	* 			  with HITACHI HD61202 LCD driver                      				 *
  *   Version:    1.1                                                    *
  *   Created:    04.10.00 12:43                                         *
  *   Author:     Gregor Horvat                                          *
  *   www:     		http:\\www.silon.si\grega\index.html                   *
  *   email:     	grega@silon.si                                         *
  ************************************************************************/
#include "HD61202.h"
#include <progmem.h>
#include "font.h"

unsigned char xx = 0, yy = 0;

// control for backlight
void glcd_BackLight(unsigned char a)
{
	if (a) sbi(glcd_Control, glcd_backLED);
	else   cbi(glcd_Control, glcd_backLED);
}

void glcd_GoTo(unsigned char x, unsigned char y)
{
  xx = x;
	yy = y;
}

void glcd_PutStr(unsigned char *data)
{
  while (*data) {
    glcd_PutChr(*data);
    data++;
  }
}

void glcd_PutChr(unsigned char chr)
{
  unsigned char a = 0, x;

  if (xx > 123) {
		xx = 0;
		yy++;
		if (yy == 8) yy = 0;
	}
	if (xx < 64){
		sbi(glcd_Control, glcd_CS1);
		x = xx;
	} else {
		sbi(glcd_Control, glcd_CS2);
		x = xx - 64;
	}
  glcd_Set_X_adrress(x);
  glcd_Set_Y_adrress(yy);
  do {
    glcd_WriteData(PRG_RDB(&font5x7[((chr - 32) * 5) + a]));
    a++;
		xx++;
    if (xx == 64) {
      cbi(glcd_Control, glcd_CS1);
      sbi(glcd_Control, glcd_CS2);
    } else if (xx == 128) {
      cbi(glcd_Control, glcd_CS2);
      sbi(glcd_Control, glcd_CS1);
      xx = 0;
      yy++;
			if (yy == 8) yy = 0;
    }
    if (xx < 64) x = xx;
		else x = xx - 64;
    glcd_Set_X_adrress(x);
    glcd_Set_Y_adrress(yy);
  } while (a < 5);
  xx++;
  if (xx == 128) xx = 0;
	else glcd_WriteData(0x00);
  cbi(glcd_Control, glcd_CS1);
  cbi(glcd_Control, glcd_CS2);
	glcd_StartLine(0);
}

void glcd_SetDot(unsigned char x, unsigned char y)
{
  unsigned char temp;

	if (x < 64)	{
    sbi(glcd_Control, glcd_CS1);
    glcd_Set_X_adrress(x);
    glcd_Set_Y_adrress(y / 8);
    temp = glcd_ReadData();    //dummy read
    temp = glcd_ReadData();
    glcd_Set_X_adrress(x);
    glcd_WriteData(temp | (1 << (y % 8)));
    cbi(glcd_Control, glcd_CS1);
  } else {
    sbi(glcd_Control, glcd_CS2);
    glcd_Set_X_adrress(x - 64);
    glcd_Set_Y_adrress(y / 8);
    temp = glcd_ReadData();    //dummy read
    temp = glcd_ReadData();
    glcd_Set_X_adrress(x - 64);
    glcd_WriteData(temp | (1 << (y % 8)));
    cbi(glcd_Control, glcd_CS2);
  }
	glcd_StartLine(0);
}

void glcd_ClrDot(unsigned char x, unsigned char y)
{
  unsigned char temp;

	if (x < 64)	{
    sbi(glcd_Control, glcd_CS1);
    glcd_Set_X_adrress(x);
    glcd_Set_Y_adrress(y / 8);
    temp = glcd_ReadData();    //dummy read
    temp = glcd_ReadData();
    glcd_Set_X_adrress(x);
    glcd_WriteData(temp & (0xff - (1 << (y % 8))));
    cbi(glcd_Control, glcd_CS1);
  } else {
    sbi(glcd_Control, glcd_CS2);
    glcd_Set_X_adrress(x - 64);
    glcd_Set_Y_adrress(y / 8);
    temp = glcd_ReadData();    //dummy read
    temp = glcd_ReadData();
    glcd_Set_X_adrress(x - 64);
    glcd_WriteData(temp & (0xff - (1 << (y % 8))));
    cbi(glcd_Control, glcd_CS2);
  }
	glcd_StartLine(0);
}

void glcd_Circle(unsigned char xcenter, unsigned char ycenter, unsigned char radius)
{
  int tswitch, y, x = 0;
  unsigned char d;

  d = ycenter - xcenter;
  y = radius;
  tswitch = 3 - 2 * radius;
  while (x <= y) {
    glcd_SetDot(xcenter + x, ycenter + y);     glcd_SetDot(xcenter + x, ycenter - y);
    glcd_SetDot(xcenter - x, ycenter + y);     glcd_SetDot(xcenter - x, ycenter - y);
    glcd_SetDot(ycenter + y - d, ycenter + x); glcd_SetDot(ycenter + y - d, ycenter - x);
    glcd_SetDot(ycenter - y - d, ycenter + x); glcd_SetDot(ycenter - y - d, ycenter - x);

    if (tswitch < 0) tswitch += (4 * x + 6);
    else {
      tswitch += (4 * (x - y) + 10);
      y--;
    }
    x++;
  }
}

void glcd_Rectangle(unsigned char x, unsigned char y, unsigned char a, unsigned char b)
{
  unsigned char j;

  for (j = 0; j < a; j++) {
		glcd_SetDot(x, y + j);
		glcd_SetDot(x + b - 1, y + j);
	}
  for (j = 0; j < b; j++)	{
		glcd_SetDot(x + j, y);
		glcd_SetDot(x + j, y + a - 1);
	}
}

void glcd_Init(void)
{
  outp(0x00, glcd_DataDir);
  cbi(glcd_Control, glcd_backLED);
  outp((1 << glcd_RS) | (1 << glcd_RW)  | (1 << glcd_Enable) | (1 << glcd_CS1) |
	     (1 << glcd_CS2)|(1<<glcd_backLED)| (1 << glcd_Reset), glcd_ContDir);
  outp((0 << glcd_RS) | (0 << glcd_RW)  | (0 << glcd_Enable) | (1 << glcd_CS1) |
	     (0 << glcd_CS2)|(1<<glcd_backLED)| (0 << glcd_Reset), glcd_Control);
  cbi(glcd_Control, glcd_Reset);
  glcd_Delay(1);
  sbi(glcd_Control, glcd_Reset);
  sbi(glcd_Control, glcd_CS1);
  glcd_WaitIfReset();
  glcd_WriteCommand(DISPLAY_ON);
  cbi(glcd_Control, glcd_CS1);
  sbi(glcd_Control, glcd_CS2);
  glcd_WaitIfReset();
  glcd_WriteCommand(DISPLAY_ON);
  cbi(glcd_Control, glcd_CS2);
  glcd_ClrScr();
}

void glcd_Delay(unsigned int p) // 1-8us      ...2-13us     ...5-31us
{                               // 10-60us    ...50-290us
  unsigned int i;               // 100-580us  ...500-2,9ms
  unsigned char j; 							// 1000-5,8ms ...5000-29ms
																// 10000-56ms ...30000-170ms
																// 50000-295ms...60000-345ms
  for (i = 0; i < p; i++) for (j = 0; j < 10; j++);
}

void glcd_WaitIfBusy(void)
{
  outp(0x00, glcd_DataDir);
  sbi(glcd_Control, glcd_RW);
  cbi(glcd_Control, glcd_RS);
  do {
    glcd_Delay(1);
    sbi(glcd_Control, glcd_Enable);
    glcd_Delay(1);
    cbi(glcd_Control, glcd_Enable);
  } while (bit_is_set(glcd_DataIn, glcd_sBUSY));
}

void glcd_WaitIfReset(void)
{
  outp(0x00, glcd_DataDir);
  sbi(glcd_Control, glcd_RW);
  cbi(glcd_Control, glcd_RS);
  do {
    glcd_Delay(1);
    sbi(glcd_Control, glcd_Enable);
    glcd_Delay(1);
    cbi(glcd_Control, glcd_Enable);
  } while (bit_is_set(glcd_DataIn, glcd_sRESET));
}

void glcd_WriteCommand(unsigned char Command)
{
  glcd_WaitIfBusy();
	cbi(glcd_Control, glcd_RW);
  cbi(glcd_Control, glcd_RS);
  outp(0xFF, glcd_DataDir);
  outp(Command, glcd_DataOut);
  sbi(glcd_Control, glcd_Enable);
  glcd_Delay(1);
  cbi(glcd_Control, glcd_Enable);
}

void glcd_WriteData(unsigned char Data)
{
  glcd_WaitIfBusy();
	cbi(glcd_Control, glcd_RW);
  sbi(glcd_Control, glcd_RS);
  outp(0xFF, glcd_DataDir);
  outp(Data, glcd_DataOut);
  sbi(glcd_Control, glcd_Enable);
  glcd_Delay(1);
  cbi(glcd_Control, glcd_Enable);
}

unsigned char glcd_ReadData(void)
{
	glcd_WaitIfBusy();
  outp(0x00, glcd_DataDir);
  sbi(glcd_Control, glcd_RW);
  sbi(glcd_Control, glcd_RS);
  sbi(glcd_Control, glcd_Enable);
  glcd_Delay(1);
  cbi(glcd_Control, glcd_Enable);
  return inp(glcd_DataIn);
}

// from left to right ( 0 : 63 )
void glcd_Set_X_adrress(unsigned char Xadrress)
{
  glcd_WriteCommand(DISPLAY_SET_Y | Xadrress);
}

// from top to bottom ( 0 : 7 )
void glcd_Set_Y_adrress(unsigned char Yadrress)
{
  glcd_WriteCommand(DISPLAY_SET_X | Yadrress);
}

// 1'st shown line - scrolling ( 0 : 63 )
void glcd_StartLine(unsigned char start)
{
  sbi(glcd_Control, glcd_CS1);
  glcd_WriteCommand(DISPLAY_START_LINE | start);
  cbi(glcd_Control, glcd_CS1);
  sbi(glcd_Control, glcd_CS2);
  glcd_WriteCommand(DISPLAY_START_LINE | start);
  cbi(glcd_Control, glcd_CS2);
}

// clear glcd
void glcd_ClrScr(void)
{
  unsigned char x, y;

	sbi(glcd_Control, glcd_CS1);
  for (y = 0; y < 8; y++) {
    glcd_Set_Y_adrress(y);
    glcd_Set_X_adrress(0);
    for (x = 0; x < 64; x++) glcd_WriteData(0);
  }
  cbi(glcd_Control, glcd_CS1);
  sbi(glcd_Control, glcd_CS2);
  for (y = 0; y < 8; y++)
	{
    glcd_Set_Y_adrress(y);
    glcd_Set_X_adrress(0);
    for (x = 0; x < 64; x++) glcd_WriteData(0);
  }
  cbi(glcd_Control, glcd_CS2);
}