/*   bin2hex   */

              
#include "stdlib.h"
#include "stdio.h"
#include "string.h"                

#define HEX 0              
#define INC 1             
#define PIC 2
#define PICEE 3
#define AVR 4
#define AVREE 5

int main(int argc, char * argv[])
{
	//               
	char szBin[50], szHex[50], szDum[50];
	int ii, jj, iType, iWord;
	int iData, iData2, iPutToMem=0;
    FILE *fpBin, *fpHex;
    
	
	if (argc<2)
		{
		printf("\nBinary to hexadecimal converter (C) 06 nov 99 John Schmidt\n\n");
		printf("bin2hex convert data from filename.bin to filename.hex or .inc\n");
		printf("The filename is without extension:\n\n");
		printf("Options:\n");
		printf("         H or nothing: *.hex:   00 01 02 03 .....\n");
		printf("         8 or 6:       *.inc:   db 017h ; ...**...\n");
		printf("         a or A:       *.avr:   .db 0x17 ; ...**...\n");
		printf("         b or B:       *.aee:   .dw 0x1717 ; ...**... ...**...\n");
		printf("         p or P:       *.pic:   retlw 0x17 ; ...**...\n");
		printf("         q or Q:       *.pee:   de 0x17 ; ...**...\n");
		printf("Use: c:>bin2hex filename [option]\n\n");
		exit(0);
		}      
		       
		
	// make filenames	
	strcpy(szBin, argv[1]);
	strcpy(szHex, argv[1]);
	// er der extension
	for (ii=0; ii<10; ++ii)
		{
		if (szBin[ii]==0) goto putext;
		if (szBin[ii]=='.') 
			{
			szHex[ii] = 0;
			goto haveext;
			}
		}
	putext:;
	strcat(szBin, ".bin");
	haveext:;
	if(argc>2)
		{
		iWord = 0;
		switch(argv[2][0])
			{
			case '6':
			case '8':
				strcat(szHex, ".inc");
				iType = INC;
				break;
			case 'a':
			case 'A':
				strcat(szHex, ".avr");
				iType = AVR;
				break;
			case 'b':
			case 'B':
				strcat(szHex, ".aee");
				iType = AVREE;
				iWord = 1;
				break;
			case 'p':
			case 'P':
				strcat(szHex, ".pic");
				iType = PIC;
				break;
			case 'q':
			case 'Q':
				strcat(szHex, ".pee");
				iType = PICEE;
				break;
			default:	
				strcat(szHex, ".hex");
				iType = HEX;
			}
		}
	else
		{			
		strcat(szHex, ".hex");
		iType = HEX;
		}
	
	fpBin = fopen(szBin,"rb"); 
	if (fpBin==NULL)
		{       
		printf("Cannot open %s\n",szBin);
		exit(1);
		}
	
	fpHex = fopen(szHex,"w"); 
	if (fpHex==NULL)
		{       
		printf("Cannot open %s\n",szHex);
		exit(1);
		}

	// read and write                      
	putchar('\n');   
	printf("Writing to %s:\n",szHex);
	ii = 0;     
	jj = 0;
	while ((iData=fgetc(fpBin))!=EOF)
		{
		// header
		switch(iType)
			{
			case INC:
			// x86 code define byte
			sprintf(szDum," db 0");
			fputs(szDum, fpHex);
			printf(" db 0");
			break;
			case AVR:
			// AVR code segment define byte
			sprintf(szDum," .db 0x");
			fputs(szDum, fpHex);
			printf(szDum);
			break;
			case AVREE:
			// AVR EEPROM segment define word 
			sprintf(szDum," .dw 0x");
			fputs(szDum, fpHex);
			printf(szDum);
			//word = (unsigned int)iData*0x0100+(unsigned int)fgetc(fpBin);
			break;
			case PIC:
			// PIC 16 code define byte for computet goto
			sprintf(szDum," retlw 0x");
			fputs(szDum, fpHex);
			printf(szDum);
			break;
			case PICEE:
			// PIC 16 code define byte for EEPROM
			sprintf(szDum," de 0x");
			fputs(szDum, fpHex);
			printf(szDum);
			break;
			}
		// BYTE
		// leading zeroes
		if (iData<16) fputc('0', fpHex);
		if (iData<16) putchar('0');
		// data
		fputs(_itoa(iData,szDum,16), fpHex);
		printf("%s", _itoa(iData,szDum,16));
		// WORD
		if (iWord)
			{
			iData2 = fgetc(fpBin);
			// second BYTE
			// leading zeroes
			if (iData2<16) fputc('0', fpHex);
			if (iData2<16) putchar('0');
			// data
			fputs(_itoa(iData2,szDum,16), fpHex);
			printf("%s", _itoa(iData2,szDum,16));
			}
		// trailer
		switch(iType)
			{
			case HEX:
			// blank or newline
			++ii; 
			jj = ii%16;
			if (jj==0) fputc('\n', fpHex);
			else       fputc(' ', fpHex);
			if (jj==0) putchar('\n');
			else       putchar(' ');
			break;
			
			case INC:
			sprintf(szDum,"h ; ");
			fputs(szDum, fpHex);
			printf("h ; ");
			for (jj=0; jj<8; ++jj)
				{
				fputc((((iData&0x80)==0)?'.':'*'), fpHex);
				putchar(((iData&0x80)==0)?'.':'*'); 
				iData <<= 1;
				}
			putchar('\n');
			fputc('\n', fpHex);
			break;

			case PIC:
			case PICEE:
			case AVR:
			case AVREE:
			sprintf(szDum," ; ");
			fputs(szDum, fpHex);
			printf(szDum);
			for (jj=0; jj<8; ++jj)
				{
				fputc((((iData&0x80)==0)?'.':'*'), fpHex);
				putchar(((iData&0x80)==0)?'.':'*'); 
				iData <<= 1;
				}
			if (iWord) fputc(' ', fpHex);
			if (iWord) putchar(' '); 
			if (iWord) for (jj=0; jj<8; ++jj)
				{
				fputc((((iData2&0x80)==0)?'.':'*'), fpHex);
				putchar(((iData2&0x80)==0)?'.':'*'); 
				iData2 <<= 1;
				}
			putchar('\n');
			fputc('\n', fpHex);
			break;
			}
		}
	              
	fclose(fpBin);              
	fclose(fpHex);              
	putchar('\n');	    
	return ii;		    
}